//
//  Pinpointing_the_Location_of_a_DeviceViewController.m
//  Pinpointing the Location of a Device
//
//  Created by Vandad Nahavandipoor on 14/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Pinpointing_the_Location_of_a_DeviceViewController.h"

@implementation Pinpointing_the_Location_of_a_DeviceViewController

@synthesize myLocationManager;

- (void)didReceiveMemoryWarning{
  [super didReceiveMemoryWarning];
}

- (void)locationManager:(CLLocationManager *)manager
    didUpdateToLocation:(CLLocation *)newLocation
           fromLocation:(CLLocation *)oldLocation{
  
  /* Otrzymano informacje o współrzędnych geograficznych. */
  
  NSLog(@"Szerokość geograficzna = %f", newLocation.coordinate.latitude);
  NSLog(@"Długość geograficzna = %f", newLocation.coordinate.longitude);
  
}

- (void)locationManager:(CLLocationManager *)manager
       didFailWithError:(NSError *)error{
  
  /* Nie udało się otrzymać informacji o współrzędnych geograficznych miejsca, w którym znajduje się urządzenie. */
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  if ([CLLocationManager locationServicesEnabled]){
    self.myLocationManager = [[CLLocationManager alloc] init];
    self.myLocationManager.delegate = self;
    
    self.myLocationManager.purpose =
    @"Dostarczenie odpowiednich funkcji na podstawie położenia urządzenia.";
    
    [self.myLocationManager startUpdatingLocation];
  } else {
    /* Usługi lokalizacji nie zostały włączone. Trzeba więc podjąć odpowiednie działanie,
      np. poprosić użytkownika o ich włączenie w urządzeniu. */
    NSLog(@"Usługi lokalizacji są wyłączone.");
  }
  
}

- (void) viewDidUnload{
  [super viewDidUnload];
  [self.myLocationManager stopUpdatingLocation];
  self.myLocationManager = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
